import 'package:photogram_admin_cp/ui/pages/user/user_credentials_section.dart';
import 'package:photogram_admin_cp/ui/pages/user/user_display_section.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';
import 'package:photogram_admin_cp/import/data.dart';

import 'package:photogram_admin_cp/ui/components/util_widgets.dart';

class UserPage extends StatefulWidget {
  const UserPage({Key? key}) : super(key: key);

  @override
  _UserEditPageState createState() => _UserEditPageState();
}

class _UserEditPageState extends State<UserPage> with AppActiveContentInfiniteMixin {
  NavigatorState? _navigatorState;
  int _userToEditId = 0;

  var _isLoadingUser = false;

  @override
  void didChangeDependencies() {
    var userId = Navigator.of(context).getValue('user');

    _userToEditId = AppUtils.intVal(userId);

    _loadUser(_userToEditId);
  }

  @override
  build(context) {
    if (_isLoadingUser) {
      return UtilWidgets.preloader('Loading...');
    }

    var userModel = activeContent.watch<UserModel>(_userToEditId);

    if (null == userModel) {
      return UtilWidgets.somethingWentWrong();
    }

    return Division(
      className: 'animate__animated animate__fadeIn',
      children: [
        Navigation(
          className: 'navbar',
          child: UnOrderedList(
            className: 'navbar-nav d-flex mx-20',
            children: [
              ListItem(
                className: 'nav-item active p-5',
                style: 'display:flex; align-content: center; align-items: center;',
                child: Image(
                  className: 'user-avatar-45',
                  src: userModel.displayImage.urlCompressed,
                ),
              ),
              ListItem(
                onClick: (event) => _navigatorState?.open(name: 'display'),
                className: 'nav-item ${_navigatorState?.currentRouteName == 'display' ? 'active' : ''}',
                child: const Anchor(className: 'nav-link', innerText: 'Display'),
              ),
              ListItem(
                onClick: (event) => _navigatorState?.open(name: 'credentials'),
                className: 'nav-item ${_navigatorState?.currentRouteName == 'credentials' ? 'active' : ''}',
                child: const Anchor(
                  className: 'nav-link',
                  innerText: 'Credentials',
                ),
              ),
            ],
          ),
        ),
        Navigator(
          key: const Key('user-page-navigator'),
          onInit: (state) => _navigatorState = state,
          onRouteChange: _onRouteChange,
          routes: const [
            Route(name: 'display', page: UserDisplaySection()),
            Route(name: 'credentials', page: UserCredentialsSection()),
          ],
        ),
      ],
    );
  }

  Future<void> _loadUser(int id) async {
    if (_isLoadingUser) return;

    var userModel = activeContent.read<UserModel>(id);

    if (null != userModel) return;

    _isLoadingUser = true;

    try {
      ResponseModel responseModel;

      responseModel = await AppProvider.of(context).apiRepo.userById(userId: id.toString());

      activeContent.handleResponse(responseModel);
    } catch (e) {
      AppLogger.exception(e);
    }

    setState(() {
      _isLoadingUser = false;
    });
  }

  void _onRouteChange(String name) async {
    // todo: not required anymore, test and remove
    // while (isRebuilding) {
    //   await Future.delayed(const Duration(milliseconds: 200), () {});
    // }

    setState(() {});
  }
}
